/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.validacion;

import ec.gob.sri.anexo.ats.validacion.ValidacionAnexoAts;
import ec.gob.sri.anexo.ats.validacion.ValidacionDuplicadosAts;
import ec.gob.sri.anexo.ats.validacion.util.OrigenValidacion;
import ec.gob.sri.anexo.exceptions.ExcepcionErroresExcedidos;
import ec.gob.sri.anexo.validacion.modelo.ContextoErrores;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.validacion.esquema.ValidacionEsquema;
import ec.gob.sri.dimm.data.impl.ConexionBD;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class ValidacionATS {
    private File archivoXML;
    private String rutaXSD;

    public ValidacionATS(File archivoXML) {
        this.archivoXML = archivoXML;
    }

    public ValidacionATS(File archivoXML, String rutaXSD) {
        this.archivoXML = archivoXML;
        this.rutaXSD = rutaXSD;
    }

    public ResultadoValidacion validarEsquema() throws FileNotFoundException {
        FileInputStream xmlFile = new FileInputStream(this.archivoXML);
        InputStream xsd = this.getEsquema();
        return ValidacionEsquema.validarEsquema((InputStream)xmlFile, (InputStream)xsd);
    }

    public ResultadoValidacion validarEsquemaAnexoAntiguo() throws FileNotFoundException {
        FileInputStream xmlFile = new FileInputStream(this.archivoXML);
        InputStream xsd = this.getEsquemaAnexoAntiguo();
        return ValidacionEsquema.validarEsquema((InputStream)xmlFile, (InputStream)xsd);
    }

    private InputStream getEsquema() {
        InputStream is = ValidacionATS.class.getResourceAsStream("/ec/gob/sri/dimm/ats/validacion/at.xsd");
        if (is == null) {
            PluginLogger.logError((String)"No se pudo obtener el esquema.", (String)"ec.gob.sri.dimm.ats.validacion");
        }
        return is;
    }

    private InputStream getEsquemaAnexoAntiguo() {
        InputStream is = ValidacionATS.class.getResourceAsStream(this.rutaXSD);
        if (is == null) {
            PluginLogger.logError((String)"No se pudo obtener el esquema.", (String)"ec.gob.sri.dimm.ats.validacion");
        }
        return is;
    }

    public ContextoErrores validarInformacion() throws InterruptedException {
        PluginLogger.logInfo((String)"************** validarInformacion *************", (String)"ec.gob.sri.dimm.ats.validacion");
        ContextoErrores ctxErrores = new ContextoErrores(100);
        ValidacionAnexoAts validacionAts = new ValidacionAnexoAts();
        try {
            ConexionBD cx = new ConexionBD();
            validacionAts.validar(new Object[]{0L, "ats", 0L, ctxErrores, 0L, this.archivoXML, cx.obtenerConexion()});
        }
        catch (ExcepcionErroresExcedidos e) {
            PluginLogger.logError((String)"Se han producido demasiados errores de validacion.", (String)"ec.gob.sri.dimm.ats.validacion", (Exception)((Object)e));
        }
        catch (Exception e) {
            PluginLogger.logError((String)"Se han producido errores inesperados", (String)"ec.gob.sri.dimm.ats.validacion", (Exception)e);
        }
        PluginLogger.logInfo((String)("VALIDACION INFORMACION: ERRORES=" + ctxErrores.getTotalErros() + "WARN=" + ctxErrores.getTotalWarnings()), (String)"ec.gob.sri.dimm.ats.validacion");
        return ctxErrores;
    }

    public ContextoErrores validarDuplicados() throws InterruptedException {
        PluginLogger.logInfo((String)"************** Validar Duplicados *************", (String)"ec.gob.sri.dimm.ats.validacion");
        ContextoErrores ctxErrores = new ContextoErrores(100);
        try {
            FileInputStream is = new FileInputStream(this.archivoXML);
            ValidacionDuplicadosAts validacionDuplicados = new ValidacionDuplicadosAts((InputStream)is, OrigenValidacion.DIMM);
            ConexionBD cx = new ConexionBD();
            validacionDuplicados.validar(new Object[]{0L, "ats", 0L, ctxErrores, 0L, this.archivoXML, cx.obtenerConexion()});
        }
        catch (ExcepcionErroresExcedidos e) {
            PluginLogger.logError((String)"Se han producido demasiados errores de validacion de duplicados.", (String)"ec.gob.sri.dimm.ats.validacion", (Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            PluginLogger.logError((String)"No se encontro el archivo para validaci\u00f3n de duplicados", (String)"ec.gob.sri.dimm.ats.validacion", (Exception)e);
        }
        PluginLogger.logInfo((String)("VALIDACION DUPLICADOS: ERRORES=" + ctxErrores.getTotalErros() + "WARN=" + ctxErrores.getTotalWarnings()), (String)"ec.gob.sri.dimm.ats.validacion");
        return ctxErrores;
    }
}

